VERSION 5.00
Begin VB.Form Interface 
   Caption         =   "ConneXions"
   ClientHeight    =   5715
   ClientLeft      =   2025
   ClientTop       =   1965
   ClientWidth     =   6630
   Icon            =   "Connexion.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   5715
   ScaleWidth      =   6630
   Begin VB.Frame frameOutput 
      Height          =   615
      Left            =   720
      TabIndex        =   12
      Top             =   3840
      Width           =   5175
      Begin VB.Label lblOutput 
         Height          =   255
         Left            =   120
         TabIndex        =   13
         Top             =   240
         Width           =   4815
      End
   End
   Begin VB.ComboBox cboAddress 
      Height          =   315
      Left            =   1800
      TabIndex        =   10
      Top             =   4920
      Width           =   1815
   End
   Begin VB.CommandButton cmdExit 
      Caption         =   "E&xit"
      Height          =   495
      Left            =   4680
      TabIndex        =   9
      Top             =   4800
      Width           =   1215
   End
   Begin VB.TextBox txtWrtCurrent 
      Height          =   375
      Left            =   4440
      TabIndex        =   8
      Text            =   "0"
      Top             =   3000
      Width           =   1695
   End
   Begin VB.TextBox txtWrtVoltage 
      Height          =   375
      Left            =   2280
      TabIndex        =   7
      Text            =   "0"
      Top             =   3000
      Width           =   1695
   End
   Begin VB.CommandButton cmdWrite 
      Caption         =   "&Set Outupt"
      Height          =   495
      Left            =   600
      TabIndex        =   6
      Top             =   3000
      Width           =   1215
   End
   Begin VB.CommandButton cmdID 
      Caption         =   "&ID"
      Height          =   495
      Left            =   600
      TabIndex        =   5
      Top             =   600
      Width           =   1215
   End
   Begin VB.TextBox txtRdCurrent 
      Height          =   375
      Left            =   4440
      TabIndex        =   4
      Top             =   1800
      Width           =   1695
   End
   Begin VB.CommandButton cmdRead 
      Caption         =   "&Read Output"
      Height          =   495
      Left            =   600
      TabIndex        =   3
      Top             =   1800
      Width           =   1215
   End
   Begin VB.TextBox txtID 
      Height          =   375
      Left            =   2280
      TabIndex        =   2
      Top             =   600
      Width           =   3855
   End
   Begin VB.TextBox txtRdVoltage 
      Height          =   375
      Left            =   2280
      TabIndex        =   1
      Top             =   1800
      Width           =   1695
   End
   Begin VB.CommandButton cmdConnect 
      Caption         =   "&Connect"
      Height          =   495
      Left            =   360
      TabIndex        =   0
      Top             =   4800
      Width           =   1215
   End
   Begin VB.Label Label6 
      Caption         =   "ID Query Result"
      Height          =   255
      Left            =   2280
      TabIndex        =   18
      Top             =   360
      Width           =   3495
   End
   Begin VB.Label Label5 
      Caption         =   "Current Readback"
      Height          =   255
      Left            =   4440
      TabIndex        =   17
      Top             =   1560
      Width           =   1695
   End
   Begin VB.Label Label4 
      Caption         =   "Voltage Readback"
      Height          =   255
      Left            =   2280
      TabIndex        =   16
      Top             =   1560
      Width           =   1695
   End
   Begin VB.Label Label3 
      Caption         =   "Current Setting"
      Height          =   255
      Left            =   4440
      TabIndex        =   15
      Top             =   2760
      Width           =   1695
   End
   Begin VB.Label Label2 
      Caption         =   "Voltage Setting"
      Height          =   255
      Left            =   2280
      TabIndex        =   14
      Top             =   2760
      Width           =   1575
   End
   Begin VB.Label Label1 
      Caption         =   "GPIB Address"
      Height          =   255
      Left            =   1800
      TabIndex        =   11
      Top             =   4680
      Width           =   1815
   End
   Begin VB.Menu mnuFile 
      Caption         =   "&File"
      Begin VB.Menu mnuExit 
         Caption         =   "Exit"
      End
   End
   Begin VB.Menu mnuRegisters 
      Caption         =   "Registers"
      Begin VB.Menu mnuStatus 
         Caption         =   "Status"
      End
      Begin VB.Menu mnuAccuStatus 
         Caption         =   "Accu. Status"
      End
      Begin VB.Menu mnuFault 
         Caption         =   "Fault"
      End
   End
   Begin VB.Menu mnuUtility 
      Caption         =   "Utility"
      Begin VB.Menu mnuSetSwitch 
         Caption         =   "Set Switches"
      End
      Begin VB.Menu mnuCheckError 
         Caption         =   "Check Error"
      End
      Begin VB.Menu mnuSetDelay 
         Caption         =   "Set Delay"
      End
      Begin VB.Menu mnuTrigger 
         Caption         =   "Trigger"
      End
      Begin VB.Menu mnuClear 
         Caption         =   "Clear"
      End
      Begin VB.Menu mnuReset 
         Caption         =   "Reset"
      End
   End
   Begin VB.Menu mnuProtection 
      Caption         =   "Protection"
      Begin VB.Menu mnuSetProtection 
         Caption         =   "Set Protection"
      End
   End
   Begin VB.Menu mnuMask 
      Caption         =   "Fault Mask"
      Begin VB.Menu mnuSetMask 
         Caption         =   "Set Masking Bits"
      End
   End
   Begin VB.Menu mnuAbout 
      Caption         =   "About"
   End
End
Attribute VB_Name = "Interface"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
Dim Connection As Boolean

Private Sub cmdConnect_Click()
    Dim response As Integer
   
    If (Connection = False) Then
        response = PS.Connect(cboAddress.Text)
        If response = PASSED Then
            Connection = True
            cmdConnect.Caption = "Disconnect"
            cmdID.Enabled = True
            cmdRead.Enabled = True
            cmdWrite.Enabled = True
            mnuRegisters.Enabled = True
            mnuUtility.Enabled = True
            mnuProtection.Enabled = True
            mnuMask.Enabled = True
        End If
    Else
        Set PS = Nothing
        cmdID.Enabled = False
        cmdRead.Enabled = False
        cmdWrite.Enabled = False
        Connection = False
        mnuRegisters.Enabled = False
        mnuUtility.Enabled = False
        mnuProtection.Enabled = False
        mnuMask.Enabled = False
        cmdConnect.Caption = "Conncect"
    End If

End Sub

Private Sub cmdExit_Click()
    End
End Sub

Private Sub cmdID_Click()

    txtID.Text = PS.ID
    frameOutput.Caption = "Command Result"
    lblOutput.Caption = "ID query complete."

End Sub

Private Sub cmdRead_Click()
    
    txtRdVoltage.Text = PS.VOUT
    txtRdCurrent.Text = PS.IOUT
    frameOutput.Caption = "Command Result"
    lblOutput.Caption = "Readback complete."
    

End Sub

Private Sub cmdWrite_Click()
    Dim ErrorValue As Integer
    
    If (IsNumeric(txtWrtVoltage.Text) And _
        IsNumeric(txtWrtCurrent.Text)) Then
        PS.VSET (txtWrtVoltage.Text)
        ErrorValue = PS.ERR
        If Not (ErrorValue > 0) Then
            PS.ISET (txtWrtCurrent.Text)
            ErrorValue = PS.ERR
            If Not (ErrorValue > 0) Then
                frameOutput.Caption = "Command Result"
                lblOutput.Caption = "Voltage and Current set."
            Else
                frameOutput.Caption = "Power Supply Error"
                lblOutput.Caption = DisplayPSError(ErrorValue)
            End If
        Else
            frameOutput.Caption = "Power Supply Error"
            lblOutput.Caption = DisplayPSError(ErrorValue)
        End If
        
    Else
        txtWrtVoltage.Text = 0
        txtWrtCurrent.Text = 0
        frameOutput.Caption = "Input Error"
        lblOutput.Caption = "Must be a numeric value."
        
    End If
End Sub

Private Sub Form_Load()
    cmdID.Enabled = False
    cmdRead.Enabled = False
    cmdWrite.Enabled = False
    mnuRegisters.Enabled = False
    mnuUtility.Enabled = False
    mnuProtection.Enabled = False
    mnuMask.Enabled = False
    Connection = False
    
    cboAddress.Text = "2"
    cboAddress.AddItem "1"
    cboAddress.AddItem "2"
    cboAddress.AddItem "3"
    cboAddress.AddItem "4"
    cboAddress.AddItem "5"
    cboAddress.AddItem "6"
    cboAddress.AddItem "7"
    cboAddress.AddItem "8"
    cboAddress.AddItem "9"
    cboAddress.AddItem "10"
    cboAddress.AddItem "11"
    cboAddress.AddItem "12"
    cboAddress.AddItem "13"
    cboAddress.AddItem "14"
    cboAddress.AddItem "15"
    cboAddress.AddItem "16"
    cboAddress.AddItem "17"
    cboAddress.AddItem "18"
    cboAddress.AddItem "19"
    cboAddress.AddItem "20"
    cboAddress.AddItem "21"
    cboAddress.AddItem "22"
    cboAddress.AddItem "23"
    cboAddress.AddItem "24"
    cboAddress.AddItem "25"
    cboAddress.AddItem "26"
    cboAddress.AddItem "27"
    cboAddress.AddItem "28"
    cboAddress.AddItem "29"
    cboAddress.AddItem "30"
    
    Reg(0) = "CV "
    Reg(1) = "CC "
    Reg(2) = " "
    Reg(3) = "OV "
    Reg(4) = "OTP "
    Reg(5) = "SD "
    Reg(6) = "FOLD "
    Reg(7) = "ERR "
    Reg(8) = "PON "
    Reg(9) = "REM "
    Reg(10) = "ACF "
    Reg(11) = "OPF "
    Reg(12) = "SNSP "


    
End Sub

Private Sub Form_Unload(Cancel As Integer)
    Set PS = Nothing
End Sub

Private Sub mnuAbout_Click()
    Load frmAbout
    frmAbout.Show vbModal
End Sub

Private Sub mnuAccuStatus_Click()
    Dim AccuStatusNumber As Integer
    Dim AccuStatusString As String
    Dim Index As Integer
    AccuStatusNumber = PS.ASTS
        
        
    For Index = 0 To 12
        If (AccuStatusNumber And (2 ^ Index)) Then
            AccuStatusString = AccuStatusString & Reg(Index)
        End If
    Next Index
    frameOutput.Caption = "Accumulated Status Register"
    lblOutput.Caption = AccuStatusString
       

End Sub

Private Sub mnuCheckError_Click()
    Dim ErrorValue As Integer
    ErrorValue = PS.ERR
    frameOutput.Caption = "Power Supply Error"
    lblOutput.Caption = DisplayPSError(ErrorValue)
End Sub

Private Sub mnuClear_Click()
    PS.CLR
    frameOutput.Caption = "Power Supply Status"
    lblOutput.Caption = "Power Supply Set to Power On State."
    

End Sub

Private Sub mnuExit_Click()
    End
End Sub

Private Sub mnuFault_Click()
    Dim FaultNumber As Integer
    Dim FaultString As String
    Dim Index As Integer
    FaultNumber = PS.FAULT
       
    For Index = 0 To 12
        If (FaultNumber And (2 ^ Index)) Then
            FaultString = FaultString & Reg(Index)
        End If
    Next Index
           
    frameOutput.Caption = "Fault Register"
    lblOutput.Caption = FaultString


End Sub

Private Sub mnuReset_Click()
    PS.RST
End Sub

Private Sub mnuSetDelay_Click()
    Load frmDelay
    frmDelay.Show vbModal
End Sub

Private Sub mnuSetMask_Click()
    Load Mask
    Mask.Show vbModal
    
End Sub

Private Sub mnuSetProtection_Click()
    Load Protection
    Protection.Show vbModal
    
End Sub

Private Sub mnuSetSwitch_Click()
    Load Switch
    Switch.Show vbModal
End Sub

Private Sub mnuStatus_Click()
    Dim StatusNumber As Integer
    Dim StatusString As String
    Dim Index As Integer
    StatusNumber = PS.STS
        
        
    For Index = 0 To 12
        If (StatusNumber And (2 ^ Index)) Then
            StatusString = StatusString & Reg(Index)
        End If
    Next Index
           
    frameOutput.Caption = "Status Register"
    lblOutput.Caption = StatusString
   
End Sub

Private Sub mnuTrigger_Click()
    PS.TRG
End Sub
